CREATE DATABASE IF NOT EXISTS clipnpic_admin
  CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE clipnpic_admin;

CREATE TABLE admin_users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100) NOT NULL,
  email VARCHAR(150) NOT NULL UNIQUE,
  password VARCHAR(255) NOT NULL,
  role ENUM('superadmin','team','supervisor','accountant','payroll') NOT NULL DEFAULT 'team',
  can_host_events TINYINT(1) NOT NULL DEFAULT 0,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE clients (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(150) NOT NULL,
  email VARCHAR(150),
  phone VARCHAR(50),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE events (
  id INT AUTO_INCREMENT PRIMARY KEY,
  client_id INT NOT NULL,
  title VARCHAR(255) NOT NULL,
  event_date DATE,
  location VARCHAR(255),
  status ENUM('pending','active','completed','archived') DEFAULT 'pending',
  upload_url VARCHAR(255) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (client_id) REFERENCES clients(id) ON DELETE CASCADE
);

CREATE TABLE event_media (
  id INT AUTO_INCREMENT PRIMARY KEY,
  event_id INT NOT NULL,
  file_url VARCHAR(255) NOT NULL,
  file_type ENUM('image','video','other') DEFAULT 'image',
  is_approved TINYINT(1) DEFAULT 1,
  uploaded_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (event_id) REFERENCES events(id) ON DELETE CASCADE
);

CREATE TABLE invoices (
  id INT AUTO_INCREMENT PRIMARY KEY,
  event_id INT NOT NULL,
  amount DECIMAL(10,2) NOT NULL,
  status ENUM('unpaid','paid','refunded','cancelled') DEFAULT 'unpaid',
  due_date DATE,
  paid_at DATETIME NULL,
  notes TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (event_id) REFERENCES events(id) ON DELETE CASCADE
);

CREATE TABLE messages (
  id INT AUTO_INCREMENT PRIMARY KEY,
  sender_type ENUM('admin','client') NOT NULL,
  sender_id INT NOT NULL,
  receiver_type ENUM('admin','client') NOT NULL,
  receiver_id INT NOT NULL,
  subject VARCHAR(255),
  body TEXT NOT NULL,
  is_read TINYINT(1) DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE settings (
  id INT AUTO_INCREMENT PRIMARY KEY,
  setting_key VARCHAR(100) UNIQUE NOT NULL,
  setting_value TEXT
);

INSERT INTO admin_users (name, email, password, role, can_host_events)
VALUES (
  'Super Admin',
  'you@example.com',
  '$2y$10$k1b0vJpS6I/5RzUXgp1W6O0U1Nvn9Mugw9GdSQldpJVg14QAn3MTa', -- password123
  'superadmin',
  1
);
