<?php
require_once __DIR__ . '/../includes/header.php';
require_role(['superadmin','supervisor']);

$users = $pdo->query('SELECT * FROM admin_users ORDER BY created_at DESC')->fetchAll();
?>
<div class="page-header">
  <div>
    <h1>Admin Users</h1>
    <div class="page-header-subtitle">Manage internal access to ClipnPic admin.</div>
  </div>
  <div>
    <a href="user-edit.php" class="btn">+ New Admin</a>
  </div>
</div>

<div class="card">
  <table class="table">
    <thead>
      <tr>
        <th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Host Events</th><th>Status</th><th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($users as $u): ?>
        <tr>
          <td><?php echo $u['id']; ?></td>
          <td><?php echo htmlspecialchars($u['name']); ?></td>
          <td><?php echo htmlspecialchars($u['email']); ?></td>
          <td><?php echo htmlspecialchars($u['role']); ?></td>
          <td><?php echo !empty($u['can_host_events']) ? 'Yes' : 'No'; ?></td>
          <td><?php echo $u['is_active'] ? 'Active' : 'Disabled'; ?></td>
          <td>
            <a href="user-edit.php?id=<?php echo $u['id']; ?>">Edit</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
