<?php
require_once __DIR__ . '/../includes/header.php';
require_role(['superadmin','supervisor']);

$id = $_GET['id'] ?? null;
$userRow = null;
$isEdit = false;

if ($id) {
    $stmt = $pdo->prepare('SELECT * FROM admin_users WHERE id = :id');
    $stmt->execute(['id' => $id]);
    $userRow = $stmt->fetch();
    if (!$userRow) {
        echo 'User not found.';
        require_once __DIR__ . '/../includes/footer.php';
        exit;
    }
    $isEdit = true;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name      = trim($_POST['name'] ?? '');
    $email     = trim($_POST['email'] ?? '');
    $role      = $_POST['role'] ?? 'team';
    $is_active = !empty($_POST['is_active']) ? 1 : 0;
    $password  = $_POST['password'] ?? '';
    $can_host_events = !empty($_POST['can_host_events']) ? 1 : 0;

    // Only superadmin can change event hosting permission
    if ($user['role'] !== 'superadmin') {
        if ($isEdit) {
            $can_host_events = (int)($userRow['can_host_events'] ?? 0);
        } else {
            $can_host_events = 0;
        }
    }

    if ($isEdit) {
        $params = [
            'name'            => $name,
            'email'           => $email,
            'role'            => $role,
            'is_active'       => $is_active,
            'can_host_events' => $can_host_events,
            'id'              => $id,
        ];
        $sql = 'UPDATE admin_users
                SET name=:name, email=:email, role=:role,
                    is_active=:is_active, can_host_events=:can_host_events';

        if (!empty($password)) {
            $sql .= ', password=:password';
            $params['password'] = password_hash($password, PASSWORD_BCRYPT);
        }

        $sql .= ' WHERE id=:id';
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
    } else {
        $stmt = $pdo->prepare('
          INSERT INTO admin_users (name,email,password,role,is_active,can_host_events)
          VALUES (:name,:email,:password,:role,:is_active,:can_host_events)
        ');
        $stmt->execute([
            'name'            => $name,
            'email'           => $email,
            'password'        => password_hash($password, PASSWORD_BCRYPT),
            'role'            => $role,
            'is_active'       => $is_active,
            'can_host_events' => $can_host_events,
        ]);
    }

    header('Location: users.php');
    exit;
}
?>
<div class="page-header">
  <div>
    <h1><?php echo $isEdit ? 'Edit Admin User' : 'New Admin User'; ?></h1>
  </div>
</div>

<div class="card">
<form method="post" class="form">
  <label>Name
    <input type="text" name="name" value="<?php echo htmlspecialchars($userRow['name'] ?? ''); ?>" required>
  </label>
  <label>Email
    <input type="email" name="email" value="<?php echo htmlspecialchars($userRow['email'] ?? ''); ?>" required>
  </label>
  <label>Role
    <select name="role">
      <?php
      $roles = ['superadmin','team','supervisor','accountant','payroll'];
      $currentRole = $userRow['role'] ?? 'team';
      foreach ($roles as $r):
      ?>
        <option value="<?php echo $r; ?>" <?php echo $r === $currentRole ? 'selected' : ''; ?>>
          <?php echo ucfirst($r); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </label>
  <label>Password <?php echo $isEdit ? '(leave blank to keep current)' : ''; ?>
    <input type="password" name="password" <?php echo $isEdit ? '' : 'required'; ?>>
  </label>
  <label>
    <input type="checkbox" name="is_active" value="1" <?php echo ($userRow['is_active'] ?? 1) ? 'checked' : ''; ?>>
    Active
  </label>
  <label>
    <input type="checkbox" name="can_host_events" value="1"
      <?php echo !empty($userRow['can_host_events']) ? 'checked' : ''; ?>
      <?php echo $user['role'] !== 'superadmin' ? 'disabled' : ''; ?>>
    Can host / create events
  </label>
  <button type="submit" class="btn">Save</button>
</form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
