<?php
require_once __DIR__ . '/../includes/header.php';

$totalEvents  = $pdo->query('SELECT COUNT(*) AS c FROM events')->fetch()['c'] ?? 0;
$totalClients = $pdo->query('SELECT COUNT(*) AS c FROM clients')->fetch()['c'] ?? 0;
$totalMedia   = $pdo->query('SELECT COUNT(*) AS c FROM event_media')->fetch()['c'] ?? 0;

$unreadStmt = $pdo->prepare('
  SELECT COUNT(*) AS c
  FROM messages
  WHERE receiver_type = "admin" AND receiver_id = :id AND is_read = 0
');
$unreadStmt->execute(['id' => $user['id']]);
$unread = $unreadStmt->fetch()['c'] ?? 0;
?>

<div class="page-header">
  <div>
    <h1>Dashboard</h1>
    <div class="page-header-subtitle">
      High-level snapshot of ClipnPic events, media, and team activity.
    </div>
  </div>
  <div>
    <?php if (can_host_events()): ?>
      <a href="event-edit.php" class="btn">+ New Event</a>
    <?php endif; ?>
  </div>
</div>

<div class="cards-grid">
  <div class="card">
    <div class="card-title">
      <span>Total Events</span>
      <span class="pill-positive">+12% vs last month</span>
    </div>
    <div class="card-value"><?php echo $totalEvents; ?></div>
    <div class="card-meta">Active & archived events</div>
  </div>

  <div class="card">
    <div class="card-title">
      <span>Clients</span>
      <span class="pill-positive">Steady</span>
    </div>
    <div class="card-value"><?php echo $totalClients; ?></div>
    <div class="card-meta">Unique event owners</div>
  </div>

  <div class="card">
    <div class="card-title">
      <span>Media Files</span>
      <span class="pill-positive">Growing</span>
    </div>
    <div class="card-value"><?php echo $totalMedia; ?></div>
    <div class="card-meta">Photos & videos uploaded</div>
  </div>

  <div class="card">
    <div class="card-title">
      <span>Unread Messages</span>
      <span class="<?php echo $unread ? 'pill-negative' : 'pill-positive'; ?>">
        <?php echo $unread ? $unread . ' pending' : 'All caught up'; ?>
      </span>
    </div>
    <div class="card-value"><?php echo $unread; ?></div>
    <div class="card-meta">Team & client conversations</div>
  </div>
</div>

<div class="grid-2">
  <div class="card">
    <div class="card-title">
      <span>Event Activity Timeline</span>
      <span>This week</span>
    </div>
    <div class="fake-chart">
      Event timeline / chart placeholder
    </div>
  </div>

  <div class="card">
    <div class="card-title">
      <span>Storage & Uploads</span>
      <span>Overview</span>
    </div>
    <ul style="list-style:none; padding-left:0; margin:0; font-size:.85rem;">
      <li><strong><?php echo $totalMedia; ?></strong> total media items</li>
      <li>Cloud storage: connect usage stats later.</li>
      <li>Tip: archive old events to keep things tidy.</li>
    </ul>
  </div>
</div>

<?php
require_once __DIR__ . '/../includes/footer.php';
