<?php
$currentPath = basename($_SERVER['PHP_SELF']);
?>
<nav>
  <div class="sidebar-section-label">Dashboards</div>
  <a href="index.php"
     class="sidebar-link <?php echo $currentPath === 'index.php' ? 'active' : ''; ?>">
    <span class="icon">🏠</span>
    <span>Overview</span>
  </a>

  <div class="sidebar-section-label">Management</div>

  <a href="events.php"
     class="sidebar-link <?php echo $currentPath === 'events.php' ? 'active' : ''; ?>">
    <span class="icon">🎉</span>
    <span>Events</span>
  </a>

  <?php if (has_role(['superadmin', 'supervisor'])): ?>
    <a href="users.php"
       class="sidebar-link <?php echo $currentPath === 'users.php' ? 'active' : ''; ?>">
      <span class="icon">👥</span>
      <span>Admin Users</span>
    </a>
  <?php endif; ?>

  <a href="messages.php"
     class="sidebar-link <?php echo $currentPath === 'messages.php' ? 'active' : ''; ?>">
    <span class="icon">💬</span>
    <span>Messages</span>
  </a>

  <?php if (has_role(['superadmin', 'accountant'])): ?>
    <a href="invoices.php"
       class="sidebar-link <?php echo $currentPath === 'invoices.php' ? 'active' : ''; ?>">
      <span class="icon">💳</span>
      <span>Invoices</span>
    </a>
  <?php endif; ?>

  <?php if (has_role('superadmin')): ?>
    <a href="settings.php"
       class="sidebar-link <?php echo $currentPath === 'settings.php' ? 'active' : ''; ?>">
      <span class="icon">⚙️</span>
      <span>Settings</span>
    </a>
  <?php endif; ?>
</nav>

<div class="sidebar-bottom">
  <div style="font-size:.8rem; color:#9ca3af;">
    Logged in as<br>
    <strong><?php echo htmlspecialchars($user['name']); ?></strong>
  </div>
</div>
