<?php
require_once __DIR__ . '/auth.php';
require_login();
$user = current_user();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>ClipnPic Admin</title>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>assets/css/admin.css">
</head>
<body>
<div class="app-shell">
  <div class="app-inner">

    <aside class="sidebar">
      <?php require __DIR__ . '/sidebar.php'; ?>
    </aside>

    <div style="flex:1; display:flex; flex-direction:column;">
      <header class="topbar">
        <div class="topbar-left">
          <div class="topbar-logo">C</div>
          <div class="topbar-title">
            <span>ClipnPic Admin</span>
            <span>Event media & team dashboard</span>
          </div>
        </div>
        <div class="topbar-right">
          <span class="badge-pill">Internal · v1</span>
          <span><?php echo htmlspecialchars($user['name']); ?> · <?php echo htmlspecialchars(ucfirst($user['role'])); ?></span>
          <a href="<?php echo BASE_URL; ?>logout.php" class="btn btn-outline">Logout</a>
        </div>
      </header>

      <div class="layout">
        <main class="main-content">
